import asyncio
from py_pli.pylib import VUnits
from py_pli.pylib import GlobalVar
import config_enum.scan_table_enum as scan_table_enum
import time as t
from datetime import datetime as DT
import socket
import os
import fnmatch

# >>>>>>>NOT TESTED YET<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

# 2021-02-25/Kay Struebing
# 2021-06-25/Kay Struebing: Data Aquisition
# Mover-Test Functions


# Global Constants
INSTRUMENT = "hostname" # Replace with Proto-Name
PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]
TODAY = DT.now().strftime('%Y%m%d')

# Data Aquisition

def get_datafile(test_function = 'test'):
    global PATH, INSTRUMENT, TODAY, BASE_NAME 
    datapath = f'{PATH}/{INSTRUMENT}_{TODAY}'
    if not os.path.isdir(datapath):
        os.mkdir(datapath)
    datafile = f'{BASE_NAME}_{test_function}_Run'
    no = len(fnmatch.filter(os.listdir(datapath), datafile + '*.csv')) + 1
    datafile = f'{datafile}{no:03d}.csv'
    return(f'{datapath}/{datafile}')

def write_data(filename, data):
    with open (filename, "a") as file:
        file.write(data)

# Mover Test Function
async def mover_time(minutes):

    # Homing
    await mover_home()

    # Write Column-Header to datafile
    filename = get_datafile('mover_time')
    write_data(filename, "TimeStamp; FocusMover; FilterModuleSlider; ScanTableX; ScanTableY; PlateDoor; ExcitLightSel; Bot.LightDir; DApSlider1; DApSlider2")

    # Cycle Test
    cycles = 10
    start = t.time()
    loops = 1
    while ((t.time() - start)/60.0 < minutes):
        print(f"Mover Loop {loops}")
        result = await all_mover(cycles)
        write_data(filename, result)
        loops += 1
    duration = (t.time() - start)/60.0

    # Write Footer to Datafile
    write_data(filename, f"===Terminated {loops} Loops, {duration:.0f} Minutes")
    print(f"\n >>End of mover_time, Data-File: '{filename}',Runtime: {duration:.0f}min, {loops} Loops============\n")

async def mover_loop(loops):
    # Homing
    await mover_home()
    filename = get_datafile('mover_loop')
    write_data(filename, "TimeStamp; FocusMover; FilterModuleSlider; ScanTableX; ScanTableY; PlateDoor; ExcitLightSel; Bot.LightDir; DApSlider1; DApSlider2")

    # Cycle Test
    cycles = 10
    start = t.time()
    for i in range(loops):
        print(f"Mover Loop {i+1}")
        result = await all_mover(cycles)
        write_data(filename, result)  
    duration = (t.time() - start)/60.0

    # Write Footer to Datafile
    write_data(filename, f"===Terminated {loops} Loops, {duration:.0f} Minutes")
    print(f"\n >>End of mover_loop, Data-File: '{filename}',Runtime: {duration:.0f}min, {loops} Loops============\n")
    

# Homing

async def mover_home():
    # Focus Mover
    try:
        err = await VUnits.instance.hal.focusMover.Home()
        print(f"focusMover Step Error: {err}")
    except:
        print("Error homing focusMover")
    # Filter Module Slider
    try:
        err = await VUnits.instance.hal.filterModuleSlider.Home()
        print(f"filterModuleSlider Step Error: {err}")
    except:
        print("Error homing filterModuleSlider")
    # Scan Table
    try:
        err = await VUnits.instance.hal.scan_table.Home()
        print(f"scan_table Step Error: {err}")
    except:
        print("Error homing scan_table")
    # Plate Door
    try:
        err = await VUnits.instance.hal.plateDoor.Home()
        print(f"plateDoor Step Error: {err}")
    except:
        print("Error homing bottomLightDirector")
    # Excitation Light Selector
    try:
        err = await VUnits.instance.hal.excitationLightSelector.Home()
        print(f"excitationLightSelector Step Error: {err}")
    except:
        print("Error homing excitationLightSelector")
    # Bottom Light Director
    try:
        err = await VUnits.instance.hal.bottomLightDirector.Home()
        print(f"bottomLightDirector Step Error: {err}")
    except:
        print("Error homing bottomLightDirector")
    # Detector Aperture Slider 1 
    try:
        err = await VUnits.instance.hal.detectorApertureSlider1.Home()
        print(f"detectorApertureSlider1 Step Error: {err}")
    except:
        print("Error homing detectorApertureSlider1")
    # Detector Aperture Slider 2
    try:
        err = await VUnits.instance.hal.detectorApertureSlider2.Home()
        print(f"detectorApertureSlider2 Step Error: {err}")
    except:
        print("Error homing detectorApertureSlider2")
    
# Moves all movers simultaniously for x cycles and writes step-errors in Logfile
async def all_mover(cycles):
    start = t.time()
    await asyncio.gather(fm_move(cycles),
                        fms_move(cycles), 
                        st_move(cycles),
                        pd_move(cycles),
                        els_move(cycles),
                        bld_move(cycles),
                        das1_move(cycles),
                        das2_move(cycles))
    duration = t.time() - start
    ts = DT.now().strftime('%Y-%m-%d_%H-%M-%S')
    fm_err = VUnits.instance.hal.focusMover.Mover.LastHomeStepErrors
    fms_err = VUnits.instance.hal.filterModuleSlider.Mover.LastHomeStepErrors
    st_err = VUnits.instance.hal.scan_table.CoreXY.LastHomeStepErrors
    els_err = VUnits.instance.hal.excitationLightSelector.Mover.LastHomeStepErrors  
    bld_err = VUnits.instance.hal.bottomLightDirector.Mover.LastHomeStepErrors
    pd_err = VUnits.instance.hal.plateDoor.Mover.LastHomeStepErrors
    das1_err = VUnits.instance.hal.detectorApertureSlider1.Mover.LastHomeStepErrors
    das2_err = VUnits.instance.hal.detectorApertureSlider2.Mover.LastHomeStepErrors
    result = f"{ts}; {fm_err}; {fms_err}; {st_err[0]}; {st_err[1]}; {pd_err}; {els_err}; {bld_err}; {das1_err}; {das2_err}"
    return(result)

async def fms(filter_nr):
    filter_slider = VUnits.instance.hal.filterModuleSlider
    await filter_slider.UseProfile(1)
    position = 55.2 + (filter_nr - 1) * 24.0
    await filter_slider.Move(position)


async def fms_move(cycles):
    filter_slider = VUnits.instance.hal.filterModuleSlider
    await filter_slider.Home()    
    await filter_slider.UseProfile(1)
    duration = 0
    step_error = 0
    for i in range(cycles):
        print(f"Cycle {i}")        
        await filter_slider.Move(22)
        await asyncio.sleep(0.5)
        await fms(1)
        start = t.time()
        for j in range(1, 6, 1):
            await fms(j+1)
        duration = duration + (t.time() - start)/5
        await filter_slider.Move(10)
    duration = duration / cycles
    await filter_slider.Home()
    print(f'=================================Time for FilterModule-Change: {duration:5.3f}')
    return(filter_slider.Mover.LastHomeStepErrors)

async def fms_perf():
    filter_slider = VUnits.instance.hal.filterModuleSlider
    await filter_slider.Home()    
    await filter_slider.UseProfile(1)
    await fms(1)
    start = t.time()
    for j in range(1, 6, 1):
        await fms(j+1)
    duration = (t.time() - start) / 5
    await filter_slider.Move(2)
    await filter_slider.Home()
    print(f'=================================Step-Error: {filter_slider.Mover.LastHomeStepErrors}')
    return(duration)

async def fm_move(cycles):
    focus_mover = VUnits.instance.hal.focusMover
    await focus_mover.Home()    
    await focus_mover.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")        
        await focus_mover.Move(3.95)
        await asyncio.sleep(0.5)
        await focus_mover.Move(16)
        await asyncio.sleep(0.5)
        await focus_mover.Move(10)
        await asyncio.sleep(0.5)
    await focus_mover.Home()
    return(focus_mover.Mover.LastHomeStepErrors)

async def pd_move(cycles):
    plate_door = VUnits.instance.hal.plateDoor
    await plate_door.Home()    
    await plate_door.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")        
        await plate_door.Open()
        await asyncio.sleep(0.5)
        await plate_door.Close()
        await asyncio.sleep(0.5)
    await plate_door.Home()
    return(plate_door.Mover.LastHomeStepErrors)

async def st_move(cycles):
    scan_table = VUnits.instance.hal.scan_table
    await scan_table.Home()
    await scan_table.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")
        await scan_table.Move(0, 176)
        await asyncio.sleep(0.5)
        await scan_table.Move(170, 176)
        await asyncio.sleep(0.5)
        await scan_table.Move(170, 0)
        await asyncio.sleep(0.5)
        await scan_table.Move(0, 0)
        await asyncio.sleep(0.5)        
    await scan_table.Home()
    return(scan_table.CoreXY.LastHomeStepErrors)

async def st_perf():
    scan_table = VUnits.instance.hal.scan_table
    await scan_table.Home()
    await scan_table.UseProfile(1)
    cols = 24
    step = 4.5
    start_x = 52.0
    start_y = 86.0
    start = t.time()
    await scan_table.Move(start_x, start_y)
    await scan_table.UseProfile(3)
    for x in range(cols):
        await scan_table.Move(start_x + x * step, start_y)
    t_x = (t.time() - start) / (cols - 1)
    await scan_table.UseProfile(1)    
    await scan_table.Home()
    print(f'Time: {t_x:.3f}, StepError X: {scan_table.CoreXY.LastHomeStepErrors[0]}, StepError Y: {scan_table.CoreXY.LastHomeStepErrors[1]}')
    return(t_x)
   
async def das1_move(cycles):
    das1 = VUnits.instance.hal.detectorApertureSlider1
    await das1.Home()  
    await das1.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")
        await das1.Move(4.4)
        await asyncio.sleep(0.5)
        await das1.Move(-4.2)
        await asyncio.sleep(0.5)
        await das1.Move(0.2)
        await asyncio.sleep(0.5)
    await das1.Home()
    step_error = das1.Mover.LastHomeStepErrors
    return(step_error)   

async def das2_move(cycles):
    das2 = VUnits.instance.hal.detectorApertureSlider2
    await das2.Home()  
    await das2.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")
        await das2.Move(4.4)
        await asyncio.sleep(0.5)
        await das2.Move(-4.2)
        await asyncio.sleep(0.5)
        await das2.Move(0.2)
        await asyncio.sleep(0.5)
    await das2.Home()
    step_error = das2.Mover.LastHomeStepErrors
    return(step_error)   


async def els_move(cycles):
    els = VUnits.instance.hal.excitationLightSelector
    await els.Home()  
    await els.UseProfile(1)
    for i in range(cycles):
        await els.Move(115)
        await asyncio.sleep(0.5)
        await els.Move(205)
        await asyncio.sleep(0.5)
        await els.Move(207)
        await asyncio.sleep(0.5)
        await els.Move(247)
        await asyncio.sleep(0.5)
        await els.Move(250)
        await asyncio.sleep(0.5)
    await els.Home()
    els_err = els.Mover.LastHomeStepErrors
    return(els_err)

async def bld_move(cycles):
    bld = VUnits.instance.hal.bottomLightDirector
    await bld.Home()  
    await bld.UseProfile(1)
    for i in range(cycles):
        await bld.Move(90)
        await asyncio.sleep(0.5)
        await bld.Move(35.25)
        await asyncio.sleep(0.5)
        await bld.Move(6.94)
        t.sleep(1)
        await bld.Move(0)
    await bld.Home()
    bld_err = bld.Mover.LastHomeStepErrors
    return(bld_err)

async def stop_():
    while True:
        asyncio.sleep(1)
        print("a")
        if GlobalVar.get_stopGC() == True:
            break
